#ifndef CLOCK_H
#define CLOCK_H
#include <time.h>
#include "defs.h"
#include "piece.h"


class cClock {

private:

    cClock( const cClock & );
    cClock &operator = ( const cClock & );

    uint watchstart;
    uint watchstop;

    bool running;
    bool modetimepermove;
    bool modemovestogo;
    bool depthlimit;

    uint movespersession;

	uint movetime[numcolours];
	uint sessiontime[numcolours];
	uint inc[numcolours];
    uint movestogo[numcolours];
	uint depth; //also gets transferred as search parameter later
	uint timepermove;
	uint starttime;
	uint stoptime;
	uint alloctime;//time allocated for the move
	uint pondertime;//time spent pondering, used for ponderhits


public:

    cClock();

    //simple clock start stop methods
    void start();
    void stop();
    uint time_elapsed();
    void print_time_elapsed();
    uint getwatchstart() { return watchstart;}
    uint getwatchstop() { return watchstop;}

    void startsearchtimer(const uint col, const uint mode, const bool ponderhit);

    //set+get time parameters for search

    void setpondertime() {pondertime = (uint)clock()-starttime;}
    void adjustforphit();
    uint getpondertime() { return pondertime; }

    void setsessiontime(const uint time, const uint col);
    void setmovetime(const uint time, const uint col);
    void setinc(const uint incr, const uint col);
    void setmovestogo(const uint moves, const uint col);
    void setdepth(const uint d);
    void settimepermove(const uint t);
    void setstarttime(const uint t );
    void setstoptime(const uint t);
    void setmodetpm(const bool tpm){ modetimepermove = tpm;}
    void setmodemtg(const bool mtg){ modemovestogo = mtg;}
    void setmodemps(const uint mps){ movespersession = mps;}
    void setdepthlimit(const bool dl){ depthlimit = dl;}
    bool getmodetpm() {return modetimepermove;}
    bool getmodemtg() {return modemovestogo;}
    bool getdepthlimit() {return depthlimit;}
    uint getmodemps(){ return movespersession;}

    uint getmovetime(const uint col) { return movetime[col];}
    uint getsessiontime(const uint col) { return sessiontime[col];}
    uint getinc(const uint col) { return inc[col];}
    uint getmovestogo(const uint col) { return movestogo[col];}
    void decrmovestogo(const uint col) {movestogo[col]--;}
	uint getdepth() { return depth;}
    uint gettimepermove() { return timepermove;}
    uint getstarttime() { return starttime;}
    uint getstoptime() { return stoptime;}
    uint getallocatedtime() { return alloctime;}

    //allocate the time based on the current variabe settings
    void allocatemovetime(const uint col, const uint status);

    //reset the time variables to start a search
    void resettimeparam(const uint col);

    //see if we've run out of time
    bool timeup();


};


#endif
